CREATE TRIGGER [dbo].[Tri_Contratos_Hist_Ins] 
ON [dbo].[Contratos]
AFTER INSERT
AS 

SET NOCOUNT ON
DECLARE @Id_Cliente					INT
DECLARE @Id_Tarjeta					VARCHAR(10)
DECLARE @Tar_Nro					VARCHAR(25)
DECLARE @Id_Contrato				INT
DECLARE @Item						SMALLINT

DECLARE [Cur_Contratos_Hist_Upd] CURSOR FOR
SELECT	Id_contrato, Id_Cliente,	 Id_Tarjeta, Tar_Nro FROM Inserted 
	WHERE ISNULL(Id_Tarjeta,'') <> '' AND ISNULL(Tar_Nro,'') <> ''
	

OPEN [Cur_Contratos_Hist_Upd]
FETCH NEXT FROM [Cur_Contratos_Hist_Upd] INTO @Id_Contrato,@Id_Cliente,@Id_Tarjeta,@Tar_Nro
WHILE (@@FETCH_STATUS = 0)
BEGIN
	SET @Item = ISNULL((SELECT MAX(Item) FROM  [dbo].[Clientes_Hist] WHERE Id_Cliente = @Id_Cliente),0) + 1

		INSERT INTO [dbo].[Clientes_Hist] 
			([Id_Cliente],[Item],[Fecha],[Id_Tipo_Cli],[Id_Cobrador],[Fecha_Alta],[Id_Motivo_Est],[Fecha_Baja]
			,[Id_Usuario],[Id_Cliente_Externo],[Id_Tarjeta],[Tar_Nro],[Tar_Fecha_Alta],[Tar_Fecha_Baja],[Id_Cliente_Ref],Id_Contrato)
		SELECT @Id_Cliente,@Item,GETDATE(),Id_Tipo_Cli,Id_Cobrador,Fecha_Alta,[Id_Motivo_Est],[Fecha_Baja]
			,0,[Id_Cliente_Externo],@Id_Tarjeta,@Tar_Nro,GETDATE(),NULL,[Id_Cliente_Ref],@Id_Contrato
		FROM Clientes	
		WHERE Id_Cliente = @Id_Cliente
	FETCH NEXT FROM [Cur_Contratos_Hist_Upd] INTO @Id_Contrato,@Id_Cliente,@Id_Tarjeta,@Tar_Nro
END
CLOSE [Cur_Contratos_Hist_Upd]
DEALLOCATE [Cur_Contratos_Hist_Upd]

